// Copyright 2025 SETKA. All Rights Reserved.
#pragma once

#include "CoreMinimal.h"
#include "Modules/ModuleManager.h"
#include "Input/Reply.h"
#include "Engine/Texture.h"

class SDockTab;
class FSpawnTabArgs;
class UTexture2D;

enum class EChannelSelection : uint8
{
    R,
    G,
    B,
    A
};

class FChannelPackerProModule : public IModuleInterface
{
public:
    /** IModuleInterface implementation */
    virtual void StartupModule() override;
    virtual void ShutdownModule() override;

private:
    /** Callback for spawning the plugin tab */
    TSharedRef<SDockTab> OnSpawnPluginTab(const FSpawnTabArgs& SpawnTabArgs);

    /** Input textures for each channel */
    TWeakObjectPtr<UTexture2D> InputTextureR;
    TWeakObjectPtr<UTexture2D> InputTextureG;
    TWeakObjectPtr<UTexture2D> InputTextureB;
    TWeakObjectPtr<UTexture2D> InputTextureA;

    /** Output Settings */
    FString OutputPackagePath = "/Game/Textures/Packed/";
    FString OutputFileName = "T__Packed";
    int32 TargetResolution = 1024;

    /** Callback for Generate button */
    FReply OnGenerateClicked();

    /** Automatically generates the output file name based on input textures */
    /* void AutoGenerateFileName(); */

    /** Helper function to create the texture asset */
    void CreateTexture(const FString& PackageName, int32 Resolution);

    /** Helper function to show notifications */
    void ShowNotification(const FText& Message, bool bSuccess);

    /** Compression Options */
    TArray<TSharedPtr<FString>> CompressionOptions;
    TSharedPtr<FString> CurrentCompressionOption;

    /** Channel selection options */
    TArray<TSharedPtr<FString>> ChannelOptions;
    TSharedPtr<FString> ChannelSelectionR;
    TSharedPtr<FString> ChannelSelectionG;
    TSharedPtr<FString> ChannelSelectionB;
    TSharedPtr<FString> ChannelSelectionA;

    /** Helper to get the enum value */
    TextureCompressionSettings GetSelectedCompressionSettings() const;

    /** Flag to track if the user has manually edited the output filename */
    bool bFileNameManuallyEdited = true;
};
